/**************************************************************************
 *                                                                        *
 *  Copyright 2014 Adobe Systems Incorporated                             *
 *  All Rights Reserved.                                                  *
 *                                                                        *
 * NOTICE:  All information contained herein is, and remains the property *
 * of Adobe Systems Incorporated and its suppliers, if any.               *
 * The intellectual and technical concepts contained herein are           *
 * proprietary to Adobe Systems Incorporated and its suppliers and may be *
 * covered by U.S. and Foreign Patents, patents in process, and are       *
 * protected by trade secret or copyright law.                            *
 * Dissemination of this information or reproduction of this material     *
 * strictly forbidden unless prior written permission is obtained from    *
 * Adobe Systems Incorporated.                                            *
 *                                                                        *
 **************************************************************************/

//    **Global Variables**

//***Warning***
//Make appropriate changes in CheckInternetConnectionUsingAjax() if there is no video at index 0 in videoLinks array
//Length of  array videoLinks and featureImages should be equal to variable numberOfFeatures
var videoLinks = new Array( "http://www.adobe.com/go/idtables",
                            "http://www.adobe.com/go/idepub",
                            "http://www.adobe.com/go/idsu",
                            "",
                            "",
                            "http://www.adobe.com/go/what_is_id",
                            "http://www.adobe.com/go/id_color_theme_tool",
                            "http://www.adobe.com/go/id_color_theme_panel",
                            "http://www.adobe.com/go/id_interactive_preview",
                            "http://www.adobe.com/go/id_cclibraries",
                            "http://www.adobe.com/go/id_productivity",
                            "http://www.adobe.com/go/id_images_table",
                            "",
                            "",
                            "http://www.adobe.com/go/id_performance",
                            "",
                            "",
                            "",
                            "",
                            "");

var learnMoreLinks = new Array( "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "http://www.adobe.com/go/publish_online_learn_more",
                            "http://www.adobe.com/go/publish_online_learn_more",
                            "http://www.adobe.com/go/id_touchws",
                            "http://www.adobe.com/go/id_ot_enhancements",
                            "http://www.adobe.com/go/id_compcc");

//Convention followed for naming of feature images appearing on second page is that 1x image has a suffix "_1x" and similarly 2x image has suffix "_2x"
//In the array featureImagesBaseNames add the names of all the feature images without the suffix which indicates the scale factor of screen
var featureImagesBaseNames = new Array("SimplifiedTables", "EPUBFixedLayout", "SeamlessUpdate", "ColorGroups", "EnhancedSearch", "WhatIsInDesign", "ColorThemeTool", "AdobeColor", "EPubInteractivity", "CCLibraries", "ProductivityEnhancements", "ImagesInTableCells", "ParaShading", "CCLibrariesJune2015", "Performance", "PublishOnline", "PublishOnline", "IDTouch", "OTFeatures", "CompCC");
var featureImages = new Array();
var featureHeadings = new Array();
var featureText = new Array();
var currentFeatureNumber = -1;
var resourceBundle;
var numberOfFeatures = 20;

//Indices of features are arranged in this array in the order they are displayed in UI from top to bottom.
//The "What is InDesign" should always be the first element in this array.
var featureOrdering = new Array(5, 16, 17, 18, 19, 15, 11, 12, 13, 14, 9, 10, 6, 7, 8, 0, 1, 2, 3, 4);

var internetConnectionAjaxCallSent = false;
var connectedToInternet = false;
var iframeOnLoadCalled = false;
var pageShowTimeOut;
var loadElementsTimeOut;

//constant variables
var videoType = "video";
var imageType = "image";


function onLoaded() {
    var csInterface = new CSInterface();
    
    loadJSX();
    
    updateThemeWithAppSkinInfo(csInterface.hostEnvironment.appSkinInfo);
    //Update the color of the panel when the theme color of the product changed.
    csInterface.addEventListener(CSInterface.THEME_COLOR_CHANGED_EVENT, onAppThemeColorChanged);
    
    //Intialising global arrays
    resourceBundle = csInterface.initResourceBundle();
    for(var i = 1; i <= numberOfFeatures; i++)
    {
        var featureHeadingKey = "Heading_Feature" + i;
        var featureTextKey = "Text_Feature" + i;

        //Creating a key by the name of "Heading_Feature10" or "Heading_Feature11" was causing
		//translation issues using data-locale in the html file.
        if(i >= 10)
            featureHeadingKey = "Heading" + i;

        featureHeadings[i-1] = resourceBundle[featureHeadingKey];
        featureText[i-1] = resourceBundle[featureTextKey];
    }

    //Initialising don't show again checkbox value
    var extScript = "$._ext_" + csInterface.hostEnvironment.appName + ".GetWhatsNewDontShowAgain()";
    evalScript(extScript, function(result) {
        var whatsnew = JSON.parse(result);
        var checkboxControl = document.getElementById("checkbox1");
        checkboxControl.checked = whatsnew.dontShowAgain;
    });

    //Making OS specific font changes
    var isWindowsOS = true;
    if(navigator.platform.indexOf("Mac") != -1)
        isWindowsOS = false;

    if(isWindowsOS)
    {
        var font = FontToBeUsed("Windows");
        $(".mainContainer").css("font-family", font);
        $(".buttonLabel").css("font-family", font);
        $(".mainContainer").css("font-weight", "normal");
        
        if(csInterface.hostEnvironment.appUILocale == "ko_KR")
            $(".month").css("padding-top","3px");
        else if(csInterface.hostEnvironment.appUILocale == "zh_CN")
            $(".month").css("padding-top","2px");

     	if(csInterface.getScaleFactor() == 2 || csInterface.getScaleFactor() == 1.5)
     	{
            $("a").css("cursor","url(image/Cur_x2_HandPoint_16_6.png) 16 6,pointer")
     	}
    }
    else
    {
        var font = FontToBeUsed("Mac");
        $(".mainContainer").css("font-family", font);
        $(".buttonLabel").css("font-family", font);
        $(".mainContainer").css("font-weight", "300");
        $(".whatsNewSection").css("min-height", "215px");
        $(".year").css("font-size", "14px");

        if(csInterface.hostEnvironment.appUILocale == "zh_CN" || csInterface.hostEnvironment.appUILocale == "zh_TW")
        {
            $(".month").css("padding-top","8px");
            $(".month").css("padding-bottom","4px");
            $(".month").css("padding-left","1px");
        }
    }

    //ja_JP specific changes
    if(csInterface.hostEnvironment.appUILocale == "ja_JP")
    {
        $(".appName").css("font-size","22px");
        $(".month").css("padding-top","8px");
        $(".month").css("line-height","17px");
        $(".month").css("padding-left","1px");
        $("body").css("font-size", "9pt");
        $(".textHeader").css("font-size","11pt");
        $("#videopage_heading").css("font-size","14pt");
    }
    else if(csInterface.hostEnvironment.appUILocale == "ko_KR")
        $(".appName").css("top","-7px");

    //Loading feature images accordng to scale factor of screen
    LoadImagesAccordingToScaleFactor();
    csInterface.setScaleFactorChangedHandler(LoadImagesAccordingToScaleFactor);

    //Disabling drop inside whatsnew
    window.ondragenter=function(){ event.dataTransfer.dropEffect='none'; event.stopPropagation(); event.preventDefault(); }  
    window.ondragover=function(){ event.dataTransfer.dropEffect='none';event.stopPropagation(); event.preventDefault(); }
    window.ondrop=function(){ event.dataTransfer.dropEffect='none';event.stopPropagation(); event.preventDefault(); }
}

function LoadImagesAccordingToScaleFactor() {
    var csInterface = new CSInterface();
    var suffix;
    if(csInterface.getScaleFactor() == 2)
        suffix = "_2x";
    else
        suffix = "_1x";
    for(var i = 0; i < numberOfFeatures; i++)
    {
        featureImages[i] = "image/" + featureImagesBaseNames[i] + suffix + ".png";
    }
}

function FontToBeUsed(os)
{
    var csInterface = new CSInterface();
    var language = csInterface.hostEnvironment.appUILocale;
    if(os == "Windows")
    {
        switch(language)
        {
            case "ja_JP":
            return    "Meiryo";
            case "ko_KR":
            return    "Malgun Gothic";
            case "zh_CN":
            return    "Microsoft YaHei";
            case "zh_TW":
            return    "Microsoft JhengHei";
            default:
            return    "Adobe Clean";
        }
    }
    else if(os == "Mac")
    {
        switch(language)
        {
            case "ja_JP":
            return    "HiraKakuProN-W3";
            case "ko_KR":
            return    "AppleGothic";
            case "zh_CN":
            return    "STXihei";
            case "zh_TW":
            return    "LiHeiPro";
            default:
            return    "Adobe Clean";
        }
    }
}

/**
 * Update the theme with the AppSkinInfo retrieved from the host product.
 */
function updateThemeWithAppSkinInfo(appSkinInfo) {
    
    //Update the background color of the panel
    var panelBackgroundColor = appSkinInfo.panelBackgroundColor.color;
    document.body.bgColor = toHex(panelBackgroundColor);
    
    var styleId = "ppstyle";
    
    var csInterface = new CSInterface();
    var appName = csInterface.hostEnvironment.appName;
    
    if(panelBackgroundColor.red > 127)
        $("#theme").attr("href","./lightTheme.css");
    else
        $("#theme").attr("href","./darkTheme.css");

    var boxShadowAttributes = "0 0 0 6px " + toHex(panelBackgroundColor, 0);
    $(".TimeStamp").css('box-shadow', boxShadowAttributes);

    addRule(styleId, ".default", "font-size:" + appSkinInfo.baseFontSize + "px" + "; color:" + reverseColor(panelBackgroundColor) + "; background-color:" + toHex(panelBackgroundColor, 20));
    addRule(styleId, "button", "border-color: " + toHex(panelBackgroundColor, -50));    
}

function addRule(stylesheetId, selector, rule) {
    var stylesheet = document.getElementById(stylesheetId);
    
    if (stylesheet) {
        stylesheet = stylesheet.sheet;
           if( stylesheet.addRule ){
               stylesheet.addRule(selector, rule);
           } else if( stylesheet.insertRule ){
               stylesheet.insertRule(selector + ' { ' + rule + ' }', stylesheet.cssRules.length);
           }
    }
}

function reverseColor(color, delta) {
    return toHex({red:Math.abs(255-color.red), green:Math.abs(255-color.green), blue:Math.abs(255-color.blue)}, delta);
}

/**
 * Convert the Color object to string in hexadecimal format;
 */
function toHex(color, delta) {
    function computeValue(value, delta) {
        var computedValue = !isNaN(delta) ? value + delta : value;
        if (computedValue < 0) {
            computedValue = 0;
        } else if (computedValue > 255) {
            computedValue = 255;
        }
        computedValue = Math.round(computedValue);
        computedValue = computedValue.toString(16);
        return computedValue.length == 1 ? "0" + computedValue : computedValue;
    }

    var hex = "";
    if (color) {
        with (color) {
             hex = computeValue(red, delta) + computeValue(green, delta) + computeValue(blue, delta);
        };
    }
    return "#" + hex;
}

function onAppThemeColorChanged(event) {
    //Should get a latest HostEnvironment object from application.
    var skinInfo = JSON.parse(window.__adobe_cep__.getHostEnvironment()).appSkinInfo;
    //Gets the style information such as color info from the skinInfo, 
    //and redraw all UI controls of your extension according to the style info.
    updateThemeWithAppSkinInfo(skinInfo);
} 

/**
 * Load JSX file into the scripting context of the product. All the jsx files in 
 * folder [ExtensionRoot]/jsx will be loaded. 
 */
function loadJSX() {
    var csInterface = new CSInterface();
    var extensionRoot = csInterface.getSystemPath(SystemPath.EXTENSION) + "/jsx/";
    csInterface.evalScript('$._ext.evalFiles("' + extensionRoot + '")');
}

function evalScript(script, callback) {
    new CSInterface().evalScript(script, callback);
}

function setVideoSource(videoSrc) {
    window.frames[0].stop();
    var video = document.getElementById("video_player");
    var frameDoc = video.contentDocument || video.contentWindow.document;
    frameDoc.documentElement.innerHTML = "";

    if(videoSrc != "")
        video.src = videoSrc;
}

function GetElementType(featureNumber)
{
    //if(featureNumber >= numberOfFeatures)
    //    alert("error");

    var elementType = imageType;
    if(featureNumber < numberOfFeatures && videoLinks[featureNumber] != "")
        elementType = videoType;

    return elementType;
}

function IsVideo(featureNumber)
{
    if(GetElementType(featureNumber) == videoType)
        return true;
    else
        return false;
}

function LoadElements(featureNumber) {

    if(IsVideo(featureNumber))
    {
        var featureImage = document.getElementById("featureLargeImage");
        featureImage.src = featureImages[featureNumber];
        featureImage.style.visibility="hidden";
        document.getElementById("noConnectionText").style.visibility="hidden";
        document.getElementById("blackScreen").style.visibility="visible";
        document.getElementById("video_buffering").style.visibility="visible";

        iframeOnLoadCalled = false;
        connectedToInternet = false;
        setVideoSource(videoLinks[featureNumber]);
        $("#videopage_heading").text(featureHeadings[featureNumber]);
        $("#videopage_text").text(featureText[featureNumber]);
	document.getElementById("learnmore").style.visibility=(learnMoreLinks[featureNumber] != "") ? "visible" : "hidden";
        CheckInternetConnectionUsingAjax();
    }
    else
    {
        setVideoSource("");
        var featureImage = document.getElementById("featureLargeImage");
        featureImage.src = featureImages[featureNumber];
        featureImage.style.visibility="visible";
        document.getElementById("noConnectionText").style.visibility="hidden";
        document.getElementById("blackScreen").style.visibility="hidden";
        document.getElementById("video_buffering").style.visibility="hdden";        
        $("#videopage_heading").text(featureHeadings[featureNumber]);
        $("#videopage_text").text(featureText[featureNumber]);
	document.getElementById("learnmore").style.visibility=(learnMoreLinks[featureNumber] != "") ? "visible" : "hidden";
    }
    LogPageVisited(featureNumber);
}

function removeLoadingImage() {
    if($('#secondpage').is(':visible'))
    {
        iframeOnLoadCalled = true;
        //if(currentFeatureNumber < numberOfVideos)
        if(IsVideo(currentFeatureNumber))
        {
            document.getElementById("video_buffering").style.visibility="hidden";
            document.getElementById("blackScreen").style.visibility="hidden";
        }
        LogVideoPlayed();
    }
}

function CheckInternetConnectionUsingAjax() {
    var status = navigator.onLine;
    if(status == false)
    {
        connectedToInternet = false;
        internetConnectionAjaxCallSent = false;
        HandleError();
        return;
    }
    else if(internetConnectionAjaxCallSent)
        return;
    
    internetConnectionAjaxCallSent = true;
    $.ajax(
    {
        type: 'HEAD',
        url: videoLinks[0],
        cache: false,
        timeout: 10000,
        success: function()
        {
            connectedToInternet = true;
            internetConnectionAjaxCallSent = false;
            LogVideoPlayed();
        },
        error: function()
        {
            connectedToInternet = false;
            internetConnectionAjaxCallSent = false;
            HandleError();
        }
    });
 }

 function HandleError() {

    //This happens in the case when user clicks on video and there is no internet connection and then user clicks on home button
    //So when handleerror is called currentfeaturenumber is -1 the alert dialog in isvideo pops up
    if(currentFeatureNumber == -1)
        return;

    if(IsVideo(currentFeatureNumber))
    {
        setVideoSource("");
         document.getElementById("noConnectionText").style.visibility="visible";
         document.getElementById("featureLargeImage").style.visibility="visible";
    }
 }

function onNextButtonClick() {

    currentFeatureNumber = GetNextFeature(currentFeatureNumber);
    clearTimeout(loadElementsTimeOut);
    loadElementsTimeOut = setTimeout( function(){LoadElements(currentFeatureNumber)}, 150);
}

function onPrevButtonClick() {

    currentFeatureNumber = GetPreviousFeature(currentFeatureNumber);
    clearTimeout(loadElementsTimeOut);
    loadElementsTimeOut = setTimeout( function(){LoadElements(currentFeatureNumber)}, 150);
}

function GetNextFeature(featureNumber) {
    for(var i = 0; i < numberOfFeatures; i++)
    {
        if(featureOrdering[i] == featureNumber)
        {
            if(i == numberOfFeatures - 1)
                return featureOrdering[0];
            else
                return featureOrdering[i + 1];
        }
    }
    return -1;
}

function GetPreviousFeature(featureNumber) {
    for(var i = 0; i < numberOfFeatures; i++)
    {
        if(featureOrdering[i] == featureNumber)
        {
            if(i == 0)
                return featureOrdering[numberOfFeatures - 1];
            else
                return featureOrdering[i - 1];
        }
    }
    return -1;
}

function onVideoClick(featureNumber) {
    $("#firstpage").hide();

    //clearTimeout for all corresponding setTimeout on div "firstpage"
    clearTimeout(pageShowTimeOut);
    pageShowTimeOut = setTimeout( function(){$("#secondpage").show()}, 100);
    currentFeatureNumber = featureNumber - 1;
    clearTimeout(loadElementsTimeOut);
    loadElementsTimeOut = setTimeout( function(){LoadElements(currentFeatureNumber)}, 100);
}

function onHomeButtonClick() {

    //clearTimeout for all corresponding setTimeout on div "secondpage"
    clearTimeout(loadElementsTimeOut);
    setVideoSource("");
    currentFeatureNumber = -1;
    $("#secondpage").hide();
    clearTimeout(pageShowTimeOut);
    pageShowTimeOut = setTimeout( function(){$("#firstpage").show()}, 100);
}

function onDoneButtonClick() {
    var csInterface = new CSInterface();
    var checkValue = document.getElementById('checkbox1').checked;

    var extScript = "$._ext_" + csInterface.hostEnvironment.appName + ".SetWhatsNewDontShowAgain(" + checkValue + ")";
    evalScript(extScript, null);

    csInterface.closeExtension();
}

function KeyDetect(event) {

    if(event.keyCode == 27) {
     //esc handling
     var csInterface = new CSInterface();
    csInterface.closeExtension();
    }
    else if(event.keyCode == 32) {
        
        //Space handling
        var link = document.getElementById("AllEnhancementsText");
        var whatsIndesignLink = document.getElementById("WhatsIndesignText");
        if(link == document.activeElement && $("#AllEnhancementsText").is(':focus') )
         OpenLinkInBrowser();
        else if(link == document.activeElement && $("#WhatsIndesignText").is(':focus') )
         onVideoClick(6);
    }
    else if(event.keyCode == 13) {
     //Enter/Return handling
     //We get the same keycode in JavaScript for both OS.
     var activeEl = $(document.activeElement);
     if(!activeEl.is(':focus') )
         onDoneButtonClick();
    }
 }

function LogVideoPlayed() {
    if( !(iframeOnLoadCalled && connectedToInternet && document.getElementById("video_player").src != "" ) )
        return;
    var featurePlayed = currentFeatureNumber + 1;
    //if(featurePlayed <= numberOfVideos)
    if(IsVideo(currentFeatureNumber))
    {
        var csInterface = new CSInterface();
        var event = new CSEvent("WhatsNew", "APPLICATION");
        event.extensionId = csInterface.getExtensionID();    
        event.data = "VideoPlayed:" + "Feature" + featurePlayed;
        csInterface.dispatchEvent(event);
    }
}

function OpenLinkInBrowser() {
    var csInterface = new CSInterface();
    var event = new CSEvent("WhatsNew", "APPLICATION");
    event.extensionId = csInterface.getExtensionID();
    event.data = "AllEnhancements:AllEnhancements";
    csInterface.dispatchEvent(event);

    var language = csInterface.hostEnvironment.appUILocale;
    if(language == "en_US")
    {
        var appLanguage = csInterface.hostEnvironment.appLocale;
        if(appLanguage == "en_AE" || appLanguage == "en_IL")
            language = appLanguage;
    }

    var localeSpecificString = "";
    if(language != "en_US") {
        var languageLength = language.length;
        localeSpecificString = language.substring(languageLength - 3);
        localeSpecificString = localeSpecificString.toLowerCase();
    }
    window.cep.util.openURLInDefaultBrowser("http://www.adobe.com/go/id_cc_new_features" + localeSpecificString);
}

function onFeatureLearnMoreClick(featureNumber) {
    if(typeof(featureNumber) == "undefined")
        featureNumber = currentFeatureNumber;

    if(featureNumber == -1 || featureNumber >= numberOfFeatures)
        return;

    var csInterface = new CSInterface();
    var language = csInterface.hostEnvironment.appUILocale;
    if(language == "en_US")
    {
        var appLanguage = csInterface.hostEnvironment.appLocale;
        if(appLanguage == "en_AE" || appLanguage == "en_IL")
            language = appLanguage;
    }

    var localeSpecificString = "";
    if(language != "en_US") {
        var languageLength = language.length;
        localeSpecificString = language.substring(languageLength - 3);
        localeSpecificString = localeSpecificString.toLowerCase();
    }
    window.cep.util.openURLInDefaultBrowser(learnMoreLinks[featureNumber] + localeSpecificString);
}

function LogPageVisited(featureNumber) {
    var featureVisited = featureNumber + 1;
    var csInterface = new CSInterface();
    var event = new CSEvent("WhatsNew", "APPLICATION");
    event.extensionId = csInterface.getExtensionID();
    event.data = "PageVisited:" + "Feature" + featureVisited;
    csInterface.dispatchEvent(event);
}
